/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class InventorySorter {
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_NAME = Comparator.comparing(o -> InventorySorter.getRegistryName((ItemStackKey)o.getKey()));
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_COUNT = (first, second) -> {
        int ret = ((Integer)second.getValue()).compareTo((Integer)first.getValue());
        return ret != 0 ? ret : InventorySorter.getRegistryName((ItemStackKey)first.getKey()).compareTo(InventorySorter.getRegistryName((ItemStackKey)second.getKey()));
    };
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_TAGS = new Comparator<Map.Entry<ItemStackKey, Integer>>(){

        @Override
        public int compare(Map.Entry<ItemStackKey, Integer> first, Map.Entry<ItemStackKey, Integer> second) {
            ItemStack secondStack;
            Item secondItem;
            ItemStack firstStack = first.getKey().getStack();
            Item firstItem = firstStack.m_41720_();
            if (firstItem == (secondItem = (secondStack = second.getKey().getStack()).m_41720_())) {
                return 0;
            }
            int ret = this.compareTags(firstStack.m_204131_().collect(Collectors.toSet()), secondStack.m_204131_().collect(Collectors.toSet()));
            return ret != 0 ? ret : InventorySorter.getRegistryName(first.getKey()).compareTo(InventorySorter.getRegistryName(second.getKey()));
        }

        private int compareTags(Set<TagKey<Item>> firstTags, Set<TagKey<Item>> secondTags) {
            int ret = Integer.compare(secondTags.size(), firstTags.size());
            if (ret != 0) {
                return ret;
            }
            if (firstTags.size() == 1) {
                return firstTags.iterator().next().f_203868_().compareTo(secondTags.iterator().next().f_203868_());
            }
            ArrayList<TagKey<Item>> firstTagsSorted = new ArrayList<TagKey<Item>>(firstTags);
            ArrayList<TagKey<Item>> secondTagsSorted = new ArrayList<TagKey<Item>>(secondTags);
            firstTagsSorted.sort(Comparator.comparing(TagKey::f_203868_));
            secondTagsSorted.sort(Comparator.comparing(TagKey::f_203868_));
            for (int i = 0; i < firstTagsSorted.size(); ++i) {
                ret = firstTagsSorted.get(i).f_203868_().compareTo(secondTagsSorted.get(i).f_203868_());
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    };

    private InventorySorter() {
    }

    private static String getRegistryName(ItemStackKey itemStackKey) {
        return itemStackKey.getStack().m_41720_().getRegistryName().toString();
    }

    public static void sortHandler(IItemHandlerModifiable handler, Comparator<? super Map.Entry<ItemStackKey, Integer>> comparator, Set<Integer> noSortSlots) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks((IItemHandler)handler, noSortSlots);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(comparator);
        int slots = handler.getSlots();
        Iterator it = sortedList.iterator();
        ItemStackKey current = null;
        int count = 0;
        for (int slot = 0; slot < slots; ++slot) {
            if (noSortSlots.contains(slot)) continue;
            if ((current == null || count <= 0) && it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                current = (ItemStackKey)entry.getKey();
                count = (Integer)entry.getValue();
            }
            if (current != null && count > 0) {
                count -= InventorySorter.placeStack(handler, current, count, slot);
                continue;
            }
            InventorySorter.emptySlot(handler, slot);
        }
    }

    private static void emptySlot(IItemHandlerModifiable handler, int slot) {
        if (!handler.getStackInSlot(slot).m_41619_()) {
            handler.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    private static int placeStack(IItemHandlerModifiable handler, ItemStackKey current, int count, int slot) {
        ItemStack copy = current.getStack().m_41777_();
        int slotLimit = handler.getSlotLimit(slot);
        int countPlaced = slotLimit > 64 ? Math.min(count, slotLimit / 64 * copy.m_41741_()) : Math.min(count, copy.m_41741_());
        copy.m_41764_(countPlaced);
        if (!ItemStack.m_41728_((ItemStack)handler.getStackInSlot(slot), (ItemStack)copy)) {
            handler.setStackInSlot(slot, copy);
        }
        return countPlaced;
    }
}

